# Cache usage

Storing items in the cache is simple. Simply call the put method on the Cache class:

```php
    Pimf\Cache::put('name', 'Rob', 10);
```

The first parameter is the key to the cache item. You will use this key to retrieve the item from the cache. The second parameter is the 
value of the item. The third parameter is the number of minutes you want the item to be cached.

You may also cache something **forever** if you do not want the cache to expire:

```php
    Pimf\Cache::forever('name', 'Rob');
```

Retrieving items from the cache is even more simple than storing them. It is done using the get method. Just mention the key of the item you wish to retrieve:

```php
    $name = Pimf\Cache::get('name');
```

By default, NULL will be returned if the cached item has expired or does not exist. However, you may pass a different default value as a second parameter to the method:

```php
    $name = Pimf\Cache::get('name', 'Rob');
```
Now, **Rob** will be returned if the **name** cache item has expired or does not exist.


PIMF even gives you a simple way to determine if a cached item exists using the has method:

```php
if (Pimf\Cache::has('name')) {
     $name = Pimf\Cache::get('name');
}
```

Need to get rid of a cached item? No problem. Just mention the name of the item to the forget method:

```php
    Pimf\Cache::forget('name');
```
